//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Globalization;

namespace FrameworkLibraries
{
	public class IFormatProviderMain 
	{
		enum Letters
		{
			A,
			B,
			C,
			D,
			E,
			F,
			G,
			H,
			I,
			J,
			K,
			L,
			M,
			N,
			O,
			P,
			Q,
			R,
			S,
			T,
			U,
			V,
			W,
			X,
			Y,
			Z
		}
		static void Main(string [] args)
		{
			double d = 123.0;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"#####", d.ToString("#####"));
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"00000", d.ToString("00000"));
			d = 1234567890.0;
			Console.WriteLine("{0} \t-> {1} \t-> {2}", d, @"(###) ### - ####", d.ToString("(###) ### - ####"));
			d = 1.2;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"#.##", d.ToString("#.##"));
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"0.00", d.ToString("0.00"));
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"00.00", d.ToString("00.00"));
			d = 1234567890.0;
			Console.WriteLine("{0} \t-> {1} \t\t\t-> {2}", d, @"#,#", d.ToString("#,#"));
			Console.WriteLine("{0} \t-> {1} \t\t\t-> {2}", d, @"#,,", d.ToString("#,,"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", d, @"#,,,", d.ToString("#,,,"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", d, @"#,##0,,", d.ToString("#,##0,,"));
			d = 0.086;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"#0.##%", d.ToString("#0.##%"));
			d = 86000;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"0.###E+0", d.ToString("0.###E+0"));
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"0.###E+000", d.ToString("0.###E+000"));
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"0.###E-000", d.ToString("0.###E-000"));
			d = 123456;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"[##-##-##]", d.ToString("[##-##-##]"));
			d = 1234;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"##;(##)", d.ToString("##;(##)"));
			d = -1234;
			Console.WriteLine("{0} \t\t-> {1} \t\t-> {2}", d, @"##;(##)", d.ToString("##;(##)"));

			DateTime now = DateTime.Now;
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", now, @"d, M", now.ToString("d, M"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", now, @"d MMMM", now.ToString("d MMMM"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", now, @"dddd MMMM yy gg", now.ToString("dddd MMMM yy gg"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", now, @"h , m: s", now.ToString("h , m: s"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", now, @"hh,mm:ss", now.ToString("hh,mm:ss"));
			Console.WriteLine("{0} \t-> {1} \t\t-> {2}", now, @"HH-mm-ss-tt", now.ToString("HH-mm-ss-tt"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", now, @"hh:mm, G\MT z", now.ToString("hh:mm, G\\MT z"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", now, @"hh:mm, G\MT zzz", now.ToString("hh:mm, G\\MT zzz"));

			Letters c = Letters.R;
			Console.WriteLine("{0} \t-> {1} \t-> {2}", c, @"G", c.ToString("G"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", c, @"F", c.ToString("F"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", c, @"D", c.ToString("D"));
			Console.WriteLine("{0} \t-> {1} \t-> {2}", c, @"X", c.ToString("X"));

		}
	}
}